<?php
session_start();
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Extract input data
$product_id = $data['product_id'] ?? null;
$customer_id = $_SESSION['customer_id'] ?? null;

// Validate required fields
if (!$product_id || !$customer_id) {
    echo json_encode(["status" => "error", "message" => "Product ID and customer ID are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$product_id = intval($product_id);
$customer_id = intval($customer_id);

// Fetch the product name from the `product` table
$product_query = "SELECT Product_name FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
$product_result = mysqli_query($conn, $product_query);

if (mysqli_num_rows($product_result) > 0) {
    $product = mysqli_fetch_assoc($product_result);
    $product_name = $product['Product_name'];
} else {
    echo json_encode(["status" => "error", "message" => "Product not found or deleted"]);
    exit;
}

// Check if the customer already has a `wishlist_no`
$wishlist_no_query = "SELECT wishlist_no FROM wish_list WHERE customer_id = '$customer_id' LIMIT 1";
$wishlist_no_result = mysqli_query($conn, $wishlist_no_query);

if (mysqli_num_rows($wishlist_no_result) > 0) {
    // Use the existing `wishlist_no` for the customer
    $row = mysqli_fetch_assoc($wishlist_no_result);
    $wishlist_no = $row['wishlist_no'];
} else {
    // Generate a new `wishlist_no`
    $max_wishlist_no_query = "SELECT MAX(CAST(SUBSTRING(wishlist_no, 5) AS UNSIGNED)) AS max_wishlist_no FROM wish_list";
    $max_wishlist_no_result = mysqli_query($conn, $max_wishlist_no_query);
    $max_wishlist_no = 0;

    if (mysqli_num_rows($max_wishlist_no_result) > 0) {
        $row = mysqli_fetch_assoc($max_wishlist_no_result);
        $max_wishlist_no = $row['max_wishlist_no'];
    }

    $new_wishlist_no_number = $max_wishlist_no + 1;
    $wishlist_no = 'WIS-' . str_pad($new_wishlist_no_number, 4, '0', STR_PAD_LEFT);
}

// Insert query to add a new entry to the `wish_list` table
$query = "INSERT INTO wish_list (wishlist_no, customer_id, product_id, product_name) 
          VALUES ('$wishlist_no', '$customer_id', $product_id, '$product_name')";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Wish list item added successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to add item to wish list"]);
}

mysqli_close($conn);
?>
